# Future Work Recommendations


![graphic](./concept_design_sketch.svg)

|Title                           |Key points                 |Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
|--------------------------------|---------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
|RoverXR  Hardware  Modifications|Integrate Pi Zero 2 W      |Possible to bypass and omit M5 Stick C on the Rover and Remote. Zero 2 W could directly convey driving commands from VR  using a second websocket stream. The M5 Rovers battery can power the Zero 2 W directly. Improved multithreading enables more complex teleoperation solutions.                                                                                                                                                                                     |
|                                |New enclosed snap-fit shell|Design fully enclosed, transparent, compliant snap-fit shell for easy access  and a more seamless aesthetic.  Making it flexible and rounded should improve feel when handling.                                                                                                                                                                                                                                                                                            |
|                                |New camera                 |Install wide field of view camera with motorised focusing.                                                                                                                                                                                                                                                                                                                                                                                                                 |
|                                |Adjustable camera angle    |Add servo for adjusting camera angle on the fly. Additionally, modify current camera mount to  accommodate additional 15 degrees to the downward facing angle.                                                                                                                                                                                                                                                                                                             |
|                                |Add shutdown button        |Expand breakout board with shutdown button for triggering poweroff command.                                                                                                                                                                                                                                                                                                                                                                                                |
|                                |Improve interface          |Add more status indicators to better inform a user of status of the device  without having to SSH in.  This could include various assortment of LEDs or a small OLED.                                                                                                                                                                                                                                                                                                      |
|                                |Develop a charging base    |Currently the setup consists of two devices, easy to misplace. With a dedicated charging base/enclosure,  they would have a place to rest & recharge.  This would in turn help to reduce the risk of misplacement.                                                                                                                                                                                                                                                         |
|                                |Add sensors                |Usually teleoperated robots are equipped with various sensors,  enabling extero- and proprioception. This could be used to complement  a new VR interface solution, which better informs the operator of both the status  of the vehicle as well as its surroundings. Three key sensory features to consider include: LiDAR, Microphone, battery voltage monitor.                                                                                                          |
|                                |Remote controller mount    |The current chassis could be extended by integrating  a simple remote controller mount. This may help reduce the chance of misplacing  either component as they are intended to work as a pair.                                                                                                                                                                                                                                                                            |
|RoverXR Software Modifications  |Improve streaming solution |The video stream solution consists of two components: a RPi based server,  serving the video stream, and a Godot scene,  which connects to the server and displays the individual frames.  Investigating alternative protocols, encoding and rendering techniques  could improve the quality of the video stream. Remote streaming configuration should also be added, such as basic video quality settings etc.                                                           |
|                                |Godot                      |The overall scene can be expanded by adding more informative interfaces.                                                                                                                                                                                                                                                                                                                                                                                                   |
|                                |Autonomous driving mode    |With an upgraded RPi unit capable of controlling movement,  autonomous operation is easier to implement.                                                                                                                                                                                                                                                                                                                                                                   |
|                                |Deploy ROS                 |This would allow for more complex teleoperation solutions, as well as provide topic based control and access to a wide variety of devices  with ready made drivers, making future development more cost effective. A Godot-ROS-Bridge could be implemented for a more seamless development experience. Ready made SLAM and autonomous driving solutions would also be available. However, this may require a further a more capable external compute component in the setup|
|                                |Control from VR            |Implement RoverXR control interface in a Godot VR scene to control the movement.                                                                                                                                                                                                                                                                                                                                                                                           |
|                                |Godot H264 decoding        |Explore ways for decoding video streams natively in Godot. One possible solution may be the 'ffmpeg-node' for Godot 3.x                                                                                                                                                                                                                                                                                                                                                    |
|RoverXR Evaluation Ideas        |Unity solution             |Prepare an equivalent interface using the Unity game engine to compare performance.                                                                                                                                                                                                                                                                                                                                                                                        |
|                                |Compare with FPV           |Comparative study to commercial drone FPV setups,  like the DJI FPV Combo product series. An OpenHD and EZ-WiFiBroadcaster implementation should also be explored.  These represent some of the most comprehensive and best performing FPV solutions.                                                                                                                                                                                                                      |
|                                |Further evaluate solution  |Ideas to explore, such as evaluating interface intuitiveness/immersiveness,  setup complexity, task completion time etc                                                                                                                                                                                                                                                                                                                                                    |
