import logging

import colorlog
import os
from jig_module import main

logging.basicConfig(level=logging.DEBUG)
handler = colorlog.StreamHandler()
handler.setFormatter(
    colorlog.ColoredFormatter("%(log_color)s%(levelname)s:%(name)s:%(message)s")
)

logger = colorlog.getLogger("main")
logger.propagate = False
logger.setLevel(logging.DEBUG)
logger.addHandler(handler)


database_conn = main.Database(logger)
database_conn.read_config_file("example.toml")
database_conn.connect()

#new_dev = main.Device(1237, 1)
#got_id = database_conn.register_device(new_dev)
#logger.info(f"got {got_id}")


while(True):
    logger.info("Enter imei")
    imei = input() 
    new_dev = main.Device(imei, 3)
    n = database_conn.register_device(new_dev)
    logger.info(f"got {n}")
    f = open("label.zpl", "w")
    f.write(f"^XA^FO125,30^BQN,2,8^FDMM,A{n}^FS^XZ")
    f.close()
    os.system("lp -d zd421 -o raw label.zpl")
