from __future__ import annotations

from datetime import date

from pydantic import BaseModel

from fastapi import Form


class PicBase(BaseModel):
    name: str | None
    description: str | None
    pictureFile: bytes
    logid: int


class Pic(PicBase):
    pictureid: int

    class Config:
        orm_mode = True


class PicCreate(PicBase):
    pass


class LogBase(BaseModel):
    name: str
    content: str | None
    date: date | None
    deviceid: int


class Log(LogBase):
    logid: int

    class Config:
        orm_mode = True


class LogCreate(LogBase):
    pass


class DeviceBase(BaseModel):
    imei: int
    proddate: date
    hwverid: int
    jigid: int


class Device(DeviceBase):
    deviceid: int

    class Config:
        orm_mode = True


class DeviceCreate(DeviceBase):
    pass


class HwVerBase(BaseModel):
    name: str


class HwVer(HwVerBase):
    hwverid: int

    class Config:
        orm_mode = True


class HwVerCreate(HwVerBase):
    pass


class JigBase(BaseModel):
    name: str
    description: str


class Jig(JigBase):
    jigid: int

    class Config:
        orm_mode = True


class JigCreate(JigBase):
    pass


class UserBase(BaseModel):
    name: str


class User(UserBase):
    passw: str

    class Config:
        orm_mode = True
