
# Database tables


::: mermaid

classDiagram
    class Device
    Device : +date proddate
    Device : int imei
    Device <|-- Log : fk_key deviceid

    Jig <|-- Device : fk_key jig

    hwVersion <|-- Device : fk_key hwid

    Log <|-- Picture : fk_key logid
 
    class Jig{
        +String name
        +String description
    }

    class hwVersion{
        +String name
    }

    class Log{
        +String name
        +String description
        +date logdate
    }

    class Picture{
        +String name
        +String description
    }

:::

---
# Crud functions

::: mermaid
classDiagram
    class DeviceCrud{
        +get_devices() : list[deviceid, imei]
        +get_device(deviceid) : device
        +get_device_by_imei(imei) : device
        +add_device(imei, hwid, jigid, proddate)
    }

    class JigCrud{
        +get_jigs(): list[jigid, name]
        +get_jig(jigid)
        +add_jig(name, description)
    }

    class LogCrud{
        +get_logs(deviceid) : list[logid, name]
        +get_log(logid) : log
        +add_log(deviceid, name, description)
    }

    class PictureCrud{
        +add_picture(logid)
        +get_pictures(logid) : list[pictureId, name]
        +get_picture(pictureid) : picture
    }

    class hwVersionCrud{
        +add_version(name)
        +get_versions() : list[hw_id, name]
    }

:::

---
# FastApi requests

## Devices

- Get list of devices
    - /device/?skip=0&limit=0
- Get device with imei
    - /device/?imei=0
- Get device with id
    - /device/?id=0
- Post device
    - /device/

---
## Logs

- Get list of logs
    - /logs/?deviceid=0&skip=0&limit=0
- Get log
    - /logs/?logid=0
- Post log
    - /logs/
- Delete log
    - /logs/delete/?logid=0
---

## Pictures

- Get list of pictures
    - /pic/?logid=0&skip=0&limit=0
- Get picture
    - /pic/file?picid=0
- Post picture
    - /pic/file{logid}
- Delete picture
    - /pic/delete/?picid=0
--- 

## Jigs

- Get list of jigs
    - /jigs/?skip=0&limit=0
- Get jig
    - /jigs/?jigid=0
- Post jig
    - /jigs/
---

## HwVersions

- Get list of hw_versions
    - /hwversions/?skip=0&limit=0
- Get hwVersion
    - /hwversions/?hwid=0
- Post hwVersion
    - /hwversions/

---
# React app

* Sisselogimine
* Otsing
* Graafikud
* QR koodi lugeja
* web app ja naitve app

---
# Python app
---

* class database
    * read_config_file()
        * Reads the toml configuration file
    * connect()
        * Connects to the database
        * Checks if the jig is registred
        * Gets the hw and jig id codes
    * register_device()
        * Registers a device and returns the id
    * get_qr()
        * Gets the qr code

* class device
   * Sends post request to server
* get_device_code()
    * Sends get request to server

---
# HMAC

* Format 
    * HTTPVerb
    * Host
    * URI
    * query parameters
    * body

---