import solid from "solid-start/vite";
import { defineConfig } from "vite";

export default defineConfig({
    plugins: [solid()],
    server: {
        host: true,
        cors: {
            origin: ["http://localhost:8000", "http://192.168.174.220:8000, http://127.0.0.1:8000"]
        },
        proxy: {
            "/api": {
                target: "http://127.0.0.1:8000",
                changeOrigin: true,
                secure: true,
                rewrite: (path) => path.replace(/^\/api/, ''),

            },
        },
    }
}); 
