import { ClientSideRowModelModule } from '@ag-grid-community/client-side-row-model';
import { ModuleRegistry } from '@ag-grid-community/core';

import AgGridSolid from '@ag-grid-community/solid';
import 'ag-grid-community/styles/ag-grid.css';
import 'ag-grid-community/styles/ag-theme-alpine.css';
import { Match, Show, Switch, createEffect, createSignal } from 'solid-js';
import { createStore, unwrap } from 'solid-js/store';
import * as restapi from "~/components/Fetch";
import { default as QrReader } from '~/components/Scanner';
ModuleRegistry.registerModules([ClientSideRowModelModule]);

export const [code, setCode] = createSignal("")
const [picture, setPicture] = createSignal()



const toBase64 = file => new Promise((resolve, reject) => {
    const reader = new FileReader();
    reader.readAsDataURL(file);
    reader.onload = () => resolve(reader.result);
    reader.onerror = reject;
});

async function postPicture(log_id, log_name) {
    if (picture()) {
        var pic = new FormData()
        let n = await toBase64(picture())
        pic.append("file", n)
        const resp = await fetch(`/api/pic/file/?logid=${log_id}&name=${log_name}`, { mode: 'cors', method: 'POST', body: pic })
        if (!resp.ok) {
            throw new Error(`HTTP error! ${resp.status}`)
        }
        const data = await resp.json();
        return data; // Return the `list` memoized value
    }
}


export default function Search() {
    let [imei, setImei] = createSignal("")
    let [deviceLogs, setDeviceLogs] = createSignal("")
    let [logData, setLogData] = createSignal("")
    let [logContent, setLogContent] = createSignal("")
    let [deviceContent, setDeviceContent] = createSignal(null)
    let [TabSelection, setTabSelection] = createSignal("")
    let [pictureName, setPictureName] = createSignal("")

    const [newLogForm, setNewLogForm] = createStore({
        name: "",
        content: "",
        date: "2023-04-04",
        deviceid: 0,
    })

    async function updateList() {
        var deviceLogs = await restapi.fetchLogList(deviceContent()[0]["deviceid"])
        console.log(deviceLogs)
        console.log("hello")
        setDeviceLogs(deviceLogs)
        setTabSelection("logs")
    }

    createEffect(async () => {
        if (TabSelection() === "logs") {
            updateList()
        } else if (TabSelection() === "log") {
            const cont = await fetchLogContent(logData()["logid"])
            setLogContent(cont)
        }
    })


    createEffect(async () => {
        if (code()) {
            var contWithCode = await fetchDeviceData(code())
            setDeviceContent(contWithCode)
            var deviceLogs = await fetchLogList(code())
            setDeviceLogs(deviceLogs)
            setTabSelection("device")
            setNewLogForm("deviceid", code())
        }
    })

    createEffect(async () => {
        if (imei()) {
            var contWithImei = await fetchDeviceDataImei(imei())
            setDeviceContent(contWithImei)
            setCode(deviceContent()[0]["deviceid"])
            setDeviceLogs(deviceLogs)
        }
    })

    createEffect(async () => {
        if (logData()) {
            console.log(logData())
            const cont = await fetchLogContent(logData()["logid"])
            setLogContent(cont)
        }
    })

    const columnDefs = [
        { field: 'logid' },
        { field: 'name' },
    ];

    const picColumnDefs = [
        { field: 'pictureid' },
        { field: 'name' },
    ];

    const defaultColDef = {
        flex: 1,
    };


    return (
        <div>
            <button data-drawer-target="default-sidebar" data-drawer-toggle="default-sidebar" aria-controls="default-sidebar" type="button" class="inline-flex items-center p-2 mt-2 ml-3 text-sm text-gray-500 rounded-lg sm:hidden hover:bg-gray-100 focus:outline-none focus:ring-2 focus:ring-gray-200  dark:focus:ring-gray-600">
                <span class="sr-only">Open sidebar</span>
                <svg class="w-6 h-6" aria-hidden="true" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                    <path clip-rule="evenodd" fill-rule="evenodd" d="M2 4.75A.75.75 0 012.75 4h14.5a.75.75 0 010 1.5H2.75A.75.75 0 012 4.75zm0 10.5a.75.75 0 01.75-.75h7.5a.75.75 0 010 1.5h-7.5a.75.75 0 01-.75-.75zM2 10a.75.75 0 01.75-.75h14.5a.75.75 0 010 1.5H2.75A.75.75 0 012 10z"></path>
                </svg>
            </button>


            <aside id="default-sidebar" class="fixed top-auto left-0 z-40 w-64 h-screen transition-transform -translate-x-full sm:translate-x-0" aria-label="Sidebar">
                <div class="h-auto px-3 py-4 overflow-y-auto bg-gray-0 bg-gray-200 border-gray-300 border rounded-br-xl">
                    <div class='text-center grid gap-1 mb-6 md:grid-cols-1'>
                        <div>
                            <label class="font-bold mb-2 text-sm">Search</label>
                        </div>
                        <div>
                            <QrReader />
                        </div>
                        <div>
                            <input
                                type='text'
                                id="seadme kood"
                                class="flex mb-2 text-sm font-medium text-green-400 rounded-lg focus:ring-blue-500 focus:border-blue-500 w-full p-2.5 bg-gray-700 border-gray-600 placeholder-gray-400 " placeholder='device id'
                                onChange={(e) => { setCode(e.currentTarget.value); setLogData(null); setDeviceContent(null) }}
                            />
                        </div>
                        <div>
                            <input
                                type='text'
                                id="seadme imei"
                                class="flex mb-2 text-sm font-medium text-gray-400 rounded-lg focus:ring-blue-500 focus:border-blue-500 w-full p-2.5 bg-gray-700 border-gray-600 dark:placeholder-gray-400 " placeholder="imei"
                                onChange={(e) => { setImei(e.currentTarget.value), setLogData(null); setDeviceContent(null) }}
                            />
                        </div>
                    </div>
                </div>
            </aside>

            <Show when={deviceContent() !== null}>
                <div class='h-screen p-4 sm:ml-64' >
                    <div class="align-middle inline-flex rounded-md shadow-sm" role="group">
                        <button data-modal-target="defaultModal" data-modal-toggle="defaultModal" type="button" onClick={() => { setTabSelection("device") }} class="px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-tl-lg hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-700 dark:border-gray-600 dark:text-white dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-blue-500 dark:focus:text-white">
                            Device
                        </button>
                        <button type="button" onClick={() => { setTabSelection("logs") }} class="px-4 py-2 text-sm font-medium text-gray-900 bg-white border-t border-b border-gray-200 hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-700 dark:border-gray-600 dark:text-white dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-blue-500 dark:focus:text-white">
                            Logs
                        </button>
                        <Show when={logData()}>
                            <button type="button" onClick={() => { setTabSelection("pictures"); fetchPictureList(logData()["logid"]) }} class="px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-tr-lg hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-2 focus:ring-blue-700 focus:text-blue-700 dark:bg-gray-700 dark:border-gray-600 dark:text-white dark:hover:text-white dark:hover:bg-gray-600 dark:focus:ring-blue-500 dark:focus:text-white">
                                Pictures
                            </button>
                        </Show>
                    </div>
                    <Switch>
                        <Match when={TabSelection() === "device"}>
                            <div class="grid h-48 md:grid-cols-1">
                                <div class="rounded-tr-lg text-gray-700 bg-gray-200 border-gray-300 border">
                                    <ul class="max-w-screen mx-4 divide-y divide-gray-800 ">
                                        <li class="pb-3 sm:pb-0">
                                            <div class="flex items-center space-x-4 mt-1">
                                                <div class="flex-shrink-0 w-8 h-8">
                                                    <p class="mx-2 text-lg font-semibold text-gray-800 ">
                                                        Device
                                                    </p>
                                                </div>
                                                <div class="flex-shrink-0 w-auto h-8">
                                                    <p class="mx-5 text-lg font-medium text-blue-500 ">
                                                        {deviceContent()[0]["deviceid"]}
                                                    </p>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="pb-3 sm:pb-0">
                                            <div class="flex items-center space-x-4">
                                                <div class="flex-shrink-0 w-8 h-8">
                                                    <p class="mx-2 text-lg font-semibold text-gray-800 ">
                                                        Imei
                                                    </p>
                                                </div>
                                                <div class="flex-shrink-0 w-auto h-8">
                                                    <p class="mx-5 text-lg font-medium text-blue-500 ">
                                                        {deviceContent()[0]["imei"]}
                                                    </p>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="pb-3 sm:pb-0">
                                            <div class="flex items-center space-x-4">
                                                <div class="flex-shrink-0 w-8 h-8">
                                                    <p class="mx-2 text-lg font-semibold text-gray-800 ">
                                                        Date
                                                    </p>
                                                </div>
                                                <div class="flex-shrink-0 w-auto h-8">
                                                    <p class="mx-5 text-lg font-medium text-blue-500 ">
                                                        {deviceContent()[0]["proddate"]}
                                                    </p>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="pb-3 sm:pb-0">
                                            <div class="flex items-center space-x-4">
                                                <div class="flex-shrink-0 w-8 h-8">
                                                    <p class="mx-2 text-lg font-semibold text-gray-800 ">
                                                        Hw
                                                    </p>
                                                </div>
                                                <div class="flex-shrink-0 w-auto h-8">
                                                    <p class="mx-5 text-lg font-medium text-blue-500 ">
                                                        {deviceContent()[0]["hwverid"]}
                                                    </p>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="">
                                            <div class="flex items-center space-x-4">
                                                <div class="flex-shrink-0 w-8 h-8">
                                                    <p class="mx-2 text-lg font-semibold text-gray-800 ">
                                                        Jig
                                                    </p>
                                                </div>
                                                <div class="flex-shrink-0 w-auto h-8">
                                                    <p class="mx-5 text-lg font-medium text-blue-500 ">
                                                        {deviceContent()[0]["jigid"]}
                                                    </p>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="my-auto text-gray-700 bg-gray-200 border-gray-300 border rounded-b-lg">
                                <div class="py-4 px-3">

                                    <div class="flex items-center" >
                                        <div class="flex-shrink-0 w-auto h-auto">
                                            <input id="name" onChange={(e) => { setNewLogForm("name", e.currentTarget.value) }} class="flex mt-2 text-sm font-medium text-green-400 rounded-lg focus:ring-blue-500 focus:border-blue-500 w-full p-2.5 bg-gray-700 border-gray-600 placeholder-gray-400 " placeholder='Log name' />
                                        </div>
                                    </div>


                                    <div class="block items-center" >
                                        <div class="flex-shrink-0 w-auto h-auto">
                                            <textarea id="content" onChange={(e) => { setNewLogForm("content", e.currentTarget.value) }} rows="4" class="flex mt-2 mb-2 text-sm font-medium text-green-400 rounded-lg focus:ring-blue-500 focus:border-blue-500 w-full p-2.5 bg-gray-700 border-gray-600 placeholder-gray-400 " placeholder='Log content' />
                                        </div>
                                    </div>

                                    <button onClick={() => { console.log(unwrap(newLogForm)); updateList(); postNewLog(newLogForm) }} class="flex py-2 px-2 mt-2 mb-2 text-sm font-medium text-green-400 rounded-lg focus:ring-blue-500 focus:border-blue-500 p-2.5 bg-blue-700 border-gray-600 placeholder-gray-400 active:bg-blue-900" > Add </button>
                                </div>

                            </div>
                        </Match>

                        <Match when={TabSelection() === "logs"}>
                            <Show when={deviceLogs()}>
                                <div style="height: 90%; width: 100%" class="ag-theme-alpine">
                                    <AgGridSolid
                                        columnDefs={columnDefs}
                                        rowData={deviceLogs()}
                                        defaultColDef={defaultColDef}
                                        rowSelection='single' onRowClicked={(e) => { console.log(e.data["logid"]); setLogData(e.data); setTabSelection("log") }} pagination={true} />
                                </div>
                            </Show>
                        </Match>
                        <Match when={TabSelection() === "pictures"}>
                            <div style="height: 30%; width: 100%" class="ag-theme-alpine">
                                <AgGridSolid
                                    columnDefs={picColumnDefs}
                                    rowData={pictureList()}
                                    defaultColDef={defaultColDef}
                                    rowSelection='single' onRowClicked={(e) => { console.log(e.data["pictureid"]); fetchPictures(e.data["pictureid"]) }} pagination={true} />
                            </div>
                            <div class="mx-auto my-auto grid">
                                {pictureFromDb()}
                            </div>
                        </Match>
                        <Match when={TabSelection() === "log"}>
                            <div class=" text-gray-700 bg-gray-300 border-gray-400 border grid-cols-3">
                                <ul class="max-w-screen mx-4 divide-y divide-gray-800 ">
                                    <li class="pb-3 sm:pb-0">
                                        <div class="flex items-center space-x-4">
                                            <div class="flex-shrink-0 w-8 h-10">
                                                <p class="mx-2 text-base font-semibold text-gray-800 ">
                                                    Name
                                                </p>
                                            </div>
                                            <div class="flex-shrink-0 w-auto h-10">
                                                <p class="mx-5 text-base font-medium text-gray-500">
                                                    {logContent()["name"]} #{logContent()["logid"]}
                                                </p>
                                            </div>
                                        </div>
                                    </li>
                                    <li class="pb-3 sm:pb-0">
                                        <div class="flex items-center space-x-4">
                                            <div class="flex-shrink-0 w-8 h-8">
                                                <p class="mx-2 text-base font-semibold text-gray-800 ">
                                                    Desc
                                                </p>
                                            </div>
                                            <div class="flex-shrink-4 w-auto h-auto">
                                                <p class="mx-5 text-base font-medium text-blue-500 ">
                                                    {logContent()["description"]}
                                                </p>
                                            </div>
                                        </div>
                                    </li>
                                    <li class="pb-3 sm:pb-0">
                                        <div class="flex items-center space-x-4">
                                            <div class="flex-shrink-0 w-8 h-8">
                                                <p class="mx-2 text-base font-semibold text-gray-800 ">
                                                    Date
                                                </p>
                                            </div>
                                            <div class="flex-shrink-0 w-auto h-8">
                                                <p class="mx-5 text-base font-medium text-blue-500 ">
                                                    {logContent()["logdate"]}
                                                </p>
                                            </div>
                                        </div>
                                    </li>
                                </ul>

                            </div>
                            <div class="my-auto text-gray-700 bg-gray-200 border-gray-300 border rounded-b-lg" >
                                <p class="font-semibold mx-4">Add new picture</p>
                                <input onChange={(e) => { setPictureName(e.target.value) }} class="block mx-4 mt-3 text-sm font-medium text-green-400 rounded-lg focus:ring-blue-500 focus:border-blue-500 w-auto p-2.5 bg-gray-700 border-gray-600 placeholder-gray-400 " placeholder='Name'></input>
                                <input onChange={(e) => { setPicture(e.target.files[0]) }} class="block w-auto mx-4 mb-5 mt-2 text-xs text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 dark:text-gray-400 focus:outline-none dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400" id="small_size" type="file" />
                                <button onClick={() => { postPicture(logContent()["logid"], pictureName()) }} class="flex py-2 px-2 mb-2 ml-4 text-sm font-medium text-green-400 rounded-lg focus:ring-blue-500 focus:border-blue-500 p-2.5 bg-blue-700 border-gray-600 placeholder-gray-400 active:bg-blue-900" > Add </button>
                            </div>
                        </Match>
                    </Switch>
                </div >
            </Show>
        </div >

    )
}



// {/* <div class=" text-gray-700 bg-gray-300 border-gray-400 border grid-cols-3">
// <ul class="max-w-screen mx-4 divide-y divide-gray-800 ">
//     <li class="pb-3 sm:pb-0">
//         <div class="flex items-center space-x-4">
//             <div class="flex-shrink-0 w-8 h-8">
//                 <p class="mx-2 text-sm font-semibold text-gray-800 ">
//                     Name
//                 </p>
//             </div>
//             <div class="flex-shrink-0 w-auto h-8">
//                 <p class="mx-5 text-sm font-medium text-blue-500 ">
//                     {/* {logContent()["name"]} #{logContent()["logid"]} */}
//                 </p>
//             </div>
//         </div>
//     </li>
//     <li class="pb-3 sm:pb-0">iVBORw0KGgoAAAANSUhEUgAAAWgAAAHYCAMAAABX8YKSAAACQF
//         <div class="flex items-center space-x-4">
//             <div class="flex-shrink-0 w-8 h-8">
//                 <p class="mx-2 text-sm font-semibold text-gray-800 ">
//                     Desc
//                 </p>
//             </div>
//             <div class="flex-shrink-4 w-auto h-auto">
//                 <p class="mx-5 text-sm font-medium text-blue-500 ">
//                     {/* {logContent()["description"]} */}
//                 </p>
//             </div>
//         </div>
//     </li>
//     <li class="pb-3 sm:pb-0">
//         <div class="flex items-center space-x-4">
//             <div class="flex-shrink-0 w-8 h-8">
//                 <p class="mx-2 text-sm font-semibold text-gray-800 ">
//                     Date
//                 </p>
//             </div>
//             <div class="flex-shrink-0 w-auto h-8">
//                 <p class="mx-5 text-sm font-medium text-blue-500 ">
//                     {/* {logContent()["logdate"]} */}
//                 </p>
//             </div>
//         </div>
//     </li>
// </ul>
// </div> */}
