import { createSignal, onMount, Show, Switch } from "solid-js";

let [loggedIn, setLoggedIn] = createSignal(false)
let [checkCred, setCheckCred] = createSignal(false)

async function checkCredentials(_name, _pass) {
    if (_name === null || _pass === null)
        return null;
    const send_data = { "name": _name, "passw": _pass }
    const correct = await fetch("https://siilipesa.ee/api/auth", { method: "POST", mode: "cors", body: JSON.stringify(send_data), headers: { "Content-Type": "application/json" } })
    return correct;
}

export default function LoginScreen() {

    let [name, SetName] = createSignal(null)
    let [pass, SetPass] = createSignal(null)
    let [failed, setFailed] = createSignal(false)

    onMount(() => {
        console.log(loggedIn())
    });

    async function doLoginProcedure() {
        if (name() !== null && pass() !== null) {
            const ret = await checkCredentials(name(), pass())
            if (ret !== null && ret.status === 200) {
                setLoggedIn(true)
                SetName(null)
                SetPass(null)
            } else {
                setFailed(true)
            }
        } else {
            setFailed(true)
        }
    }

    return (
        <main >
            <Switch>
                <Match when={loggedIn() === false}>
                    <div class="grid place-items-center mt-10">
                        <div class="bg-gray-200 rounded-lg w-64 h-36 grid place-items-center">
                            <p >
                                <input class="flex my-2 text-sm font-medium text-green-400 rounded-lg focus:ring-blue-500 focus:border-blue-500 p-2.5 bg-gray-700 border-gray-600 placeholder-gray-400" placeholder='username' onChange={(e) => { SetName(e.currentTarget.value); setFailed(false) }} />
                                <input class="flex my-2 text-sm font-medium text-green-400 rounded-lg focus:ring-blue-500 focus:border-blue-500 p-2.5 bg-gray-700 border-gray-600 placeholder-gray-400" placeholder='password' onChange={(e) => { SetPass(e.currentTarget.value); setFailed(false) }} />
                            </p>
                            <button onClick={(e) => { doLoginProcedure() }} class="bg-gray-400 mb-2 font-semibold rounded-md w-16 h-auto">Login</button>
                        </div>
                        <Show when={failed()}> <p class="text-red-600"> Login failed</p> </Show>

                    </div>
                </Match>
                <Match when={loggedIn() === true}>
                    <div class="grid place-items-center mt-10">
                        <div class="bg-gray-200 rounded-lg w-64 h-36 grid place-items-center">
                            <button onClick={(e) => { setLoggedIn(false) }} class="bg-gray-400 mb-2 font-semibold rounded-md w-16 h-auto">Log out</button>
                        </div>
                    </div>
                </Match>
            </Switch>
        </main>
    );
}
