
import { createResource, createSignal, onCleanup, onMount } from 'solid-js';

import { ReadQrCode } from './QrReader';

async function fetchData(dest) {
    console.log(dest)
    if (dest && dest != "") {
        const resp = await fetch(`/api/device/?deviceid=1`, { mode: 'cors', method: 'get' })
        if (!resp.ok) {
            throw new Error(`HTTP error! ${resp.status}`)
        }
        const data = await resp.json();
        let ret = [data]
        return ret; // Return the `list` memoized value
    }
}

export default function QrReader() {
    const [source, setSource] = createSignal();
    let res = {
        code: 0
    };
    const getStream = () => navigator.mediaDevices.getUserMedia({
        audio: false,
        video: {
            facingMode: "environment"
        },
    }).then(stream => {
        setSource(stream)
        let hasCode = ReadQrCode(stream)
        if (hasCode) {
            console.log("here", hasCode)
        }
    }).catch(alert);

    onCleanup(() => {
        if (source()) {
            source().getTracks().forEach(track => track.stop());
        }
    });

    onMount(() => {
        getStream();
    });

    return (
        <main>
            <div class="mx-auto my-auto w-auto py-2 px-1 text-gray-700 p-4">
                <video
                    style={{ border: "1px solid red" }}
                    prop:srcObject={source()}
                    autoplay
                    muted
                    playsinline
                    onclick={getStream}
                />
            </div>
        </main>
    );
}

