import jsQR from 'jsqr';
import {
    createSignal
} from 'solid-js';
import { setCode } from '~/routes/search';
export function ReadQrCode(stream) {
    const [qrCode, setQrCode] = createSignal();
    const video = document.createElement("video");
    video.srcObject = stream;
    video.play();

    const canvas = document.createElement("canvas");
    const canvasContext = canvas.getContext("2d");
    const frameDelay = 200;

    const scanFrame = () => {
        canvas.width = video.videoWidth;
        canvas.height = video.videoHeight;
        canvasContext.drawImage(video, 0, 0, canvas.width, canvas.height);
        const imageData = canvasContext.getImageData(0, 0, canvas.width, canvas.height);
        const code = jsQR(imageData.data, imageData.width, imageData.height);
        if (code) {
            console.log(code)
            setQrCode(code.data)
            setCode(code.data)
        }
        setTimeout(() => requestAnimationFrame(scanFrame), frameDelay);
    };

    setTimeout(() => requestAnimationFrame(scanFrame), frameDelay);
    return qrCode();
};