import logging

import colorlog

from jig_module import main

logging.basicConfig(level=logging.DEBUG)
handler = colorlog.StreamHandler()
handler.setFormatter(
    colorlog.ColoredFormatter("%(log_color)s%(levelname)s:%(name)s:%(message)s")
)

logger = colorlog.getLogger("main")
logger.propagate = False
logger.setLevel(logging.DEBUG)
logger.addHandler(handler)


database_conn = main.Database(logger)
database_conn.read_config_file("example.toml")
database_conn.connect()


new_dev = main.Device(1234, 1)
got_id = database_conn.register_device(new_dev)
logger.info(f"got {got_id}")
