/*
 * Decompiled with CFR 0.152.
 */
package project.karnaughmapsolver;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.PerspectiveCamera;
import javafx.scene.SubScene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import project.karnaughmapsolver.CubeModelBuilder;
import project.karnaughmapsolver.KMap;
import project.karnaughmapsolver.ValueSet;

public class MainViewController
implements Initializable {
    private KMap kMap;
    String letters = "ABCDEFG";
    @FXML
    private TableView<ValueSet> truthTable;
    @FXML
    private ChoiceBox<Integer> variablesChoiceBox;
    @FXML
    private Slider spacingSlider;
    @FXML
    private Slider textOpacitySlider;
    @FXML
    private Slider cellOpacitySlider;
    @FXML
    private Slider focusSlider;
    @FXML
    public GridPane extraSettings;
    @FXML
    public CheckBox show3D;
    @FXML
    private MenuItem empty;
    @FXML
    private MenuItem exit;
    @FXML
    private MenuItem about;
    @FXML
    private MenuItem help;
    @FXML
    private CheckMenuItem showOnlyRelevant;
    @FXML
    private CheckMenuItem showIndexes;
    @FXML
    private RadioMenuItem initZeros;
    @FXML
    private RadioMenuItem initOnes;
    @FXML
    private RadioMenuItem initDontCares;
    @FXML
    private RadioMenuItem initRandom;
    @FXML
    public AnchorPane SOPParent;
    @FXML
    public AnchorPane POSParent;
    @FXML
    public Canvas canvasPOS;
    @FXML
    public Canvas canvasSOP;
    @FXML
    private TextFlow solutionTextPOS;
    @FXML
    private TextFlow solutionTextSOP;
    @FXML
    private Button inputButton;
    private CubeModelBuilder cubeModelBuilderSOP;
    private CubeModelBuilder cubeModelBuilderPOS;

    @FXML
    private void allSetZeroClicked() {
        this.setAll('0');
    }

    @FXML
    private void allSetOneClicked() {
        this.setAll('1');
    }

    @FXML
    private void allSetDoNotCareClicked() {
        this.setAll('?');
    }

    @FXML
    private void allSetRandomizedClicked() {
        Random rand = new Random();
        char rand_int = (char)(rand.nextInt(2) + 48);
        this.setRandom(rand_int);
    }

    @FXML
    private void solveButtonClicked() {
        this.solve();
    }

    @FXML
    private void reset3DModel() {
        if (this.show3D.isSelected()) {
            this.cubeModelBuilderSOP.resetRotation();
            this.cubeModelBuilderPOS.resetRotation();
        }
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.initMenuItems();
        this.initTruthTable();
    }

    public void updateKMap() {
        this.kMap = new KMap(this.truthTable.getItems(), this.variablesChoiceBox.getValue());
    }

    private void setAll(char c) {
        if (!this.truthTable.getItems().isEmpty()) {
            for (ValueSet item : this.truthTable.getItems()) {
                item.setF(c);
            }
            this.truthTable.refresh();
            this.updateKMap();
            this.updateCanvas();
        }
    }

    private void setRandom(char c) {
        if (!this.truthTable.getItems().isEmpty()) {
            for (ValueSet item : this.truthTable.getItems()) {
                Random rand = new Random();
                char rand_int = (char)(rand.nextInt(2) + 48);
                item.setF(rand_int);
            }
            this.truthTable.refresh();
            this.updateKMap();
            this.updateCanvas();
        }
    }

    private void initTruthTable() {
        this.truthTable.setOnMouseClicked(event -> {
            ValueSet focusedItem = (ValueSet)this.truthTable.getFocusModel().getFocusedItem();
            if (focusedItem != null && this.truthTable.getFocusModel().getFocusedCell().getColumn() == this.variablesChoiceBox.getValue() + 1) {
                focusedItem.rotateF();
                this.updateKMap();
                this.updateCanvas();
                this.truthTable.refresh();
            }
        });
    }

    private void initMenuItems() {
        this.variablesChoiceBox.getItems().addAll((Integer[])new Integer[]{2, 3, 4, 5, 6});
        this.variablesChoiceBox.setOnAction(event -> {
            this.variableChange();
            if (this.variablesChoiceBox.getValue() > 5) {
                this.focusSlider.setMax(3.0);
            } else {
                this.focusSlider.setMax(1.0);
            }
        });
        this.showIndexes.setOnAction(event -> this.updateCanvas());
        this.showOnlyRelevant.setOnAction(event -> this.updateCanvas());
        this.show3D.setOnAction(event -> {
            this.updateCanvas();
            if (!this.show3D.isSelected()) {
                this.SOPParent.getChildren().remove(1);
                this.POSParent.getChildren().remove(1);
            }
            this.extraSettings.setDisable(!this.show3D.isSelected());
        });
        this.exit.setOnAction(event -> System.exit(0));
        ToggleGroup tg = new ToggleGroup();
        this.initZeros.setToggleGroup(tg);
        this.initOnes.setToggleGroup(tg);
        this.initDontCares.setToggleGroup(tg);
        this.initRandom.setToggleGroup(tg);
        this.initZeros.setSelected(true);
        this.spacingSlider.setMin(2.0);
        this.spacingSlider.setMax(50.0);
        this.spacingSlider.setValue(15.0);
        this.spacingSlider.setOnMouseDragged(event -> this.updateCanvas());
        this.textOpacitySlider.setMin(0.0);
        this.textOpacitySlider.setMax(10.0);
        this.textOpacitySlider.setValue(5.0);
        this.textOpacitySlider.setOnMouseDragged(event -> this.updateCanvas());
        this.cellOpacitySlider.setMin(3.0);
        this.cellOpacitySlider.setMax(10.0);
        this.cellOpacitySlider.setValue(8.0);
        this.cellOpacitySlider.setOnMouseDragged(event -> this.updateCanvas());
        this.focusSlider.setMin(0.0);
        this.focusSlider.setMax(1.0);
        this.focusSlider.setValue(0.0);
        this.focusSlider.setBlockIncrement(1.0);
        this.focusSlider.setMajorTickUnit(1.0);
        this.focusSlider.setMinorTickCount(0);
        this.focusSlider.setSnapToTicks(true);
        this.focusSlider.setShowTickMarks(true);
        this.focusSlider.setOnMouseDragged(event -> this.updateCanvas());
        this.focusSlider.setOnMouseReleased(event -> this.updateCanvas());
        Integer choice = this.variablesChoiceBox.getValue();
        this.inputButton.setDisable(choice == null);
        this.empty.setOnAction(event -> {
            this.variablesChoiceBox.setOnAction(event1 -> {});
            this.variablesChoiceBox.getSelectionModel().clearSelection();
            this.variablesChoiceBox.setOnAction(event1 -> {
                this.variableChange();
                if (this.variablesChoiceBox.getValue() > 5) {
                    this.focusSlider.setMax(3.0);
                } else {
                    this.focusSlider.setMax(1.0);
                }
            });
            this.truthTable.getItems().clear();
            this.truthTable.refresh();
            this.canvasPOS.getGraphicsContext2D().clearRect(0.0, 0.0, this.canvasPOS.getWidth(), this.canvasPOS.getHeight());
            this.canvasSOP.getGraphicsContext2D().clearRect(0.0, 0.0, this.canvasSOP.getWidth(), this.canvasSOP.getHeight());
            this.solutionTextSOP.getChildren().clear();
            this.solutionTextPOS.getChildren().clear();
            this.extraSettings.setDisable(true);
            this.show3D.setDisable(true);
        });
        this.about.setOnAction(event -> {
            Alert alert = new Alert(Alert.AlertType.NONE, "", ButtonType.OK);
            alert.setTitle("About");
            String content = "About the authors\n\nThis is an application was first developed by Kaarel K\u00fctt in 2022 for simplifying boolean functions using Karnaugh Map method.\n\nIn 2023 the application was further developed by Kristjan Laid with the addition of 3D model of the karnaugh Map method\n\nas well as adding new variable, optimizing code, schemes presented with only NAND and NORs and other developments\n";
            TextArea area = new TextArea(content);
            area.setWrapText(true);
            area.setEditable(false);
            alert.getDialogPane().setContent(area);
            alert.setResizable(true);
            alert.showAndWait();
        });
        this.help.setOnAction(event -> {
            Alert alert = new Alert(Alert.AlertType.NONE, "", ButtonType.OK);
            alert.setTitle("Help");
            String content = "What is a Karnaugh Map\n\nKarnaugh Map is a a method used for simplifying Boolean algebra expressions. It was first intoduced by Maurice Karnaugh in 1953\n\nas a refined method of Veitch's chart which was itself a rediscovery of Marquand diagram. Karnaugh maps are also known as\n\nKarnaugh-Veitch maps.\n\nHow to use this application\n\nStep 1) Choose the number of variables\n\nStep 2) Either use Set all 0, Set all 1 or Set all ? or you can also manually set each row y value by clicking on them.\n\nStep 3) From settings you can toggle indexes and showing only relevant values to declutter the view.\n\nStep 4) Click on Solve and the result will show up in the bottom of the window.\n\nStep 5) Check Show in 3D to see the Karnaugh Map in 3d view which can be panned and rotated in all directions.\n";
            TextArea area = new TextArea(content);
            area.setWrapText(true);
            area.setEditable(false);
            alert.getDialogPane().setContent(area);
            alert.setResizable(true);
            alert.showAndWait();
        });
        this.inputButton.setOnAction(event -> {
            TextInputDialog dialog = new TextInputDialog();
            dialog.setTitle("Enter input names");
            Label info = new Label("Input names must be inserted without spaces\nand as many variables you want,\none char counts as one variable.\nThe variable choice will be changed to\nhow many variables you enter.");
            info.setWrapText(true);
            dialog.getDialogPane().setHeader(info);
            Optional result = dialog.showAndWait();
            result.ifPresent(string -> {
                if (string.length() == 0) {
                    this.letters = "ABCDEFG";
                } else {
                    this.variablesChoiceBox.setValue(string.length());
                    this.letters = string;
                    this.variableChange();
                }
            });
        });
    }

    private void variableChange() {
        this.show3D.setDisable(this.variablesChoiceBox.getValue() < 5);
        this.extraSettings.setDisable(this.variablesChoiceBox.getValue() < 5 || !this.show3D.isSelected());
        this.focusSlider.setValue(0.0);
        Integer choice = this.variablesChoiceBox.getValue();
        this.inputButton.setDisable(choice == null);
        this.loadTruthTable();
        this.updateKMap();
        this.updateCanvas();
    }

    private void loadTruthTable() {
        int numberOfVariables = this.variablesChoiceBox.getValue();
        int numberOfRows = (int)Math.pow(2.0, numberOfVariables);
        char[] letterArr = new char[this.letters.length()];
        this.letters.getChars(0, this.letters.length(), letterArr, 0);
        this.truthTable.getItems().clear();
        this.truthTable.getColumns().clear();
        TableColumn indexColumn = new TableColumn("i");
        indexColumn.setCellValueFactory(new PropertyValueFactory("index"));
        indexColumn.setPrefWidth(20.0);
        indexColumn.setResizable(false);
        indexColumn.setStyle("-fx-font-weight: bold;-fx-font-size: 10px;");
        this.truthTable.getColumns().add(indexColumn);
        for (int i2 = 0; i2 < numberOfVariables; ++i2) {
            TableColumn column = new TableColumn(String.valueOf(letterArr[i2]));
            column.setCellValueFactory(new PropertyValueFactory("x" + i2));
            column.setPrefWidth(20.0);
            column.setSortable(false);
            column.setResizable(false);
            this.truthTable.getColumns().add(column);
        }
        TableColumn column = new TableColumn("y");
        column.setCellValueFactory(new PropertyValueFactory("f"));
        column.setPrefWidth(30.0);
        column.setResizable(false);
        column.setStyle("-fx-font-weight: bold;");
        this.truthTable.getColumns().add(column);
        this.truthTable.setRowFactory(s -> {
            TableRow row = new TableRow();
            row.setOnMouseEntered(event -> {
                if (row.getItem() != null) {
                    this.truthTable.getItems().forEach(v -> v.setClicked(false));
                    ((ValueSet)row.getItem()).setClicked(true);
                    this.updateCanvas();
                }
            });
            row.setOnMouseExited(event -> {
                if (row.getItem() != null) {
                    ((ValueSet)row.getItem()).setClicked(false);
                    this.updateCanvas();
                }
            });
            return row;
        });
        int idx = 0;
        for (int i3 = 0; i3 < numberOfRows; ++i3) {
            char initValue;
            if (this.initZeros.isSelected()) {
                initValue = '0';
            } else if (this.initOnes.isSelected()) {
                initValue = '1';
            } else if (this.initRandom.isSelected()) {
                char rand_int;
                Random rand = new Random();
                initValue = rand_int = (char)(rand.nextInt(2) + 48);
            } else {
                initValue = '?';
            }
            ValueSet valueSet = new ValueSet(i3, numberOfVariables, initValue, idx, this.letters);
            this.truthTable.getItems().add(valueSet);
            ++idx;
        }
        this.truthTable.refresh();
    }

    public void updateCanvas() {
        if (this.truthTable.getItems().isEmpty()) {
            return;
        }
        if (this.show3D.isSelected() && this.SOPParent.getChildren().size() <= 1 && this.POSParent.getChildren().size() <= 1) {
            int numberOfVariables = this.variablesChoiceBox.getValue();
            Group groupSOP = new Group();
            Group groupPOS = new Group();
            PerspectiveCamera perspectiveCameraSOP = new PerspectiveCamera(true);
            PerspectiveCamera perspectiveCameraPOS = new PerspectiveCamera(true);
            this.cubeModelBuilderSOP = new CubeModelBuilder(groupSOP, perspectiveCameraSOP, numberOfVariables, this.kMap, "SOP");
            SubScene subSceneSOP = this.cubeModelBuilderSOP.createScene();
            this.cubeModelBuilderPOS = new CubeModelBuilder(groupPOS, perspectiveCameraPOS, numberOfVariables, this.kMap, "POS");
            SubScene subScenePOS = this.cubeModelBuilderPOS.createScene();
            this.SOPParent.getChildren().add(subSceneSOP);
            this.POSParent.getChildren().add(subScenePOS);
        } else if (this.show3D.isSelected() && this.SOPParent.getChildren().size() >= 2 && this.POSParent.getChildren().size() >= 2) {
            this.cubeModelBuilderSOP.refreshCubeValues();
            this.cubeModelBuilderPOS.refreshCubeValues();
        }
        GraphicsContext[] graphicsContexts = new GraphicsContext[]{this.canvasPOS.getGraphicsContext2D(), this.canvasSOP.getGraphicsContext2D()};
        int rectSize = 35;
        for (GraphicsContext context : graphicsContexts) {
            context.clearRect(0.0, 0.0, context.getCanvas().getWidth(), context.getCanvas().getHeight());
            context.setLineWidth(2.0);
            for (int z = this.kMap.sizeZ() - 1; z >= 0; --z) {
                if (this.show3D.isSelected()) continue;
                context.setStroke(Color.web("444444"));
                context.setFill(Color.web("444444"));
                int xOffset = z * 2 * rectSize;
                int yOffset = 0;
                for (int x = 0; x < this.kMap.sizeX(); ++x) {
                    int _x = x;
                    if (z == 1 && this.kMap.sizeZ() == 2) {
                        _x = this.kMap.sizeX() - x - 1;
                        xOffset = 4 * rectSize;
                    }
                    if (this.kMap.sizeZ() == 4) {
                        _x = z % 2 == 1 ? 1 - x / 2 : x / 2;
                        yOffset = x < 2 ? x % 2 * 4 * rectSize : 4 * rectSize - x % 2 * 4 * rectSize;
                    }
                    for (int y = 0; y < this.kMap.sizeY(); ++y) {
                        int _y = y;
                        if (this.kMap.sizeZ() == 4 && (x == 1 || x == 2)) {
                            _y = this.kMap.sizeY() - 1 - y;
                        }
                        this.drawElement(_x, _y, xOffset, yOffset, rectSize, this.kMap.getValue(x, y, z), context);
                    }
                }
            }
            this.drawHeaders(context, rectSize);
        }
    }

    private void drawHeaders(GraphicsContext context, int rectSize) {
        int limY;
        int limX;
        int variables = this.variablesChoiceBox.getValue();
        context.setFont(new Font(15.0));
        context.setFill(Color.web("444444"));
        context.strokeLine(20.0, 10.0, 50.0, 40.0);
        if (this.show3D.isSelected() && variables > 4) {
            context.strokeLine(80 + 4 * rectSize, 10.0, 50 + 4 * rectSize, 40.0);
        }
        String[][] labels = new String[][]{{"0", "1"}, {"00", "01", "11", "10"}, {"000", "001", "011", "010", "110", "111", "101", "100"}, {"111"}, {"0000", "0001", "0011", "0010", "0110", "0111", "0101", "0100", "1100", "1101", "1111", "1110", "1010", "1011", "1001", "1000"}};
        int charIndex = 0;
        int limZ = this.show3D.isSelected() && variables > 4 ? (variables > 5 ? 4 : 2) : 0;
        context.fillText(this.letters.substring(charIndex, charIndex + limZ / 2), 80 + 4 * rectSize, 25.0);
        charIndex += limZ / 2;
        for (int i2 = 0; i2 < limZ; ++i2) {
            context.fillText(labels[limZ / 4][i2], (double)(63 + 4 * rectSize) + (double)i2 * Math.max(this.spacingSlider.getValue(), 12.0), 43.0 + (double)i2 * Math.max(this.spacingSlider.getValue(), 12.0));
        }
        int n = !this.show3D.isSelected() && variables > 6 ? 16 : (!this.show3D.isSelected() && variables > 4 ? 8 : (limX = variables > 2 ? 4 : 2));
        if (limX == 16) {
            context.fillText(this.letters.substring(charIndex, 4), 30.0, 12.0);
        } else {
            context.fillText(this.letters.substring(charIndex, charIndex + limX / 4 + 1), 30.0, 12.0);
        }
        charIndex = charIndex + limX / 4 + 1;
        for (int i3 = 0; i3 < limX; ++i3) {
            context.fillText(labels[limX / 4][i3], 62 + i3 * rectSize - limX / 4 * 3, 35.0);
        }
        int n2 = !this.show3D.isSelected() && variables > 5 ? 8 : (limY = variables > 3 ? 4 : 2);
        if (limY == 8 && limX == 16) {
            context.fillText(this.letters.substring(4), 10 - limY, 35.0);
        } else {
            context.fillText(this.letters.substring(charIndex, charIndex + limY / 4 + 1), 10 - limY, 35.0);
        }
        for (int i4 = 0; i4 < limY; ++i4) {
            context.fillText(labels[limY / 4][i4], 30 - limY / 4 * 3, 62 + i4 * rectSize);
        }
    }

    private void drawElement(int x, int y, int xOffset, int yOffset, int rectSize, ValueSet valueSet, GraphicsContext context) {
        Paint paint = context.getFill();
        List<ValueSet> implicants = this.getAllValueImplicants(valueSet, context);
        for (ValueSet implicant : implicants) {
            double opacity = implicant.isHighlighted() ? 0.9 : (13.0 - this.cellOpacitySlider.getValue()) / 10.0 * 0.2;
            context.setFill(Color.web(implicant.getColor(), opacity));
            context.fillRect(50 + xOffset + x * rectSize, 40 + yOffset + y * rectSize, rectSize, rectSize);
        }
        if (valueSet.isClicked()) {
            context.setFill(Color.web("0096c9", 0.9));
            context.fillRect(51 + xOffset + x * rectSize, 41 + yOffset + y * rectSize, rectSize - 1, rectSize - 1);
        }
        context.strokeRect(50 + xOffset + x * rectSize, 40 + yOffset + y * rectSize, rectSize, rectSize);
        context.setFill(paint);
        if (!this.showOnlyRelevant.isSelected() || valueSet.getF() != '0' && context.getCanvas() == this.canvasSOP || valueSet.getF() != '1' && context.getCanvas() == this.canvasPOS) {
            context.setFont(new Font(20.0));
            context.fillText(String.valueOf(valueSet.getF()), 60 + xOffset + x * rectSize, 60 + yOffset + y * rectSize);
        }
        if (this.showIndexes.isSelected()) {
            context.setFont(new Font(9.0));
            context.fillText(String.valueOf(valueSet.getIndex()), 72 + xOffset + x * rectSize, 72 + yOffset + y * rectSize);
        }
    }

    private List<ValueSet> getAllValueImplicants(ValueSet valueSet, GraphicsContext context) {
        List<ValueSet> implicants;
        ArrayList<ValueSet> valueSets = new ArrayList<ValueSet>();
        List<ValueSet> list = implicants = context.getCanvas() == this.canvasSOP ? this.kMap.getPrimeImplicantsSOP() : this.kMap.getPrimeImplicantsPOS();
        if (implicants != null) {
            for (ValueSet implicant : implicants) {
                if (!implicant.contains(valueSet)) continue;
                valueSets.add(implicant);
            }
        }
        return valueSets;
    }

    private void solve() {
        Text text;
        Matcher m;
        Pattern p;
        String formula;
        this.kMap.findImplicants();
        try {
            char[] lets = new char[this.letters.length()];
            this.letters.getChars(0, this.letters.length(), lets, 0);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        this.solutionTextSOP.getChildren().clear();
        this.solutionTextPOS.getChildren().clear();
        this.solutionTextSOP.getChildren().add(new Text("Prime implicants: \n"));
        this.solutionTextPOS.getChildren().add(new Text("Prime implicants: \n"));
        int sumSOP = 0;
        int sumPOS = 0;
        for (int i2 = 0; i2 < this.kMap.getPrimeImplicantsSOP().size(); ++i2) {
            ValueSet valueSet = this.kMap.getPrimeImplicantsSOP().get(i2);
            Object formula2 = valueSet.getFormulaSOP(this.letters);
            Pattern p2 = Pattern.compile("\\d+");
            Matcher m2 = p2.matcher((CharSequence)formula2);
            while (m2.find()) {
                sumSOP += Integer.parseInt(m2.group());
            }
            formula2 = ((String)formula2).replaceAll("\\d", "");
            Text text2 = new Text((String)formula2);
            this.bindTextWithValueSet(text2, valueSet);
            Text sign = new Text(i2 == this.kMap.getPrimeImplicantsSOP().size() - 1 ? "" : " + ");
            this.solutionTextSOP.getChildren().addAll((Node[])new Node[]{text2, sign});
        }
        int SOPgates = this.getGateCount(this.getTextFromTextFlow(this.solutionTextSOP), "+");
        int gateCountSOP = this.getGateCount(this.getTextFromTextFlow(this.solutionTextSOP), "+") + sumSOP;
        if (this.kMap.getPrimeImplicantsSOP().size() == 0) {
            this.solutionTextSOP.getChildren().add(new Text("0"));
        }
        for (ValueSet valueSet : this.kMap.getPrimeImplicantsPOS()) {
            String formula3 = valueSet.getFormulaPOS(this.letters);
            Pattern p3 = Pattern.compile("\\d+");
            Matcher m3 = p3.matcher(formula3);
            while (m3.find()) {
                sumPOS += Integer.parseInt(m3.group());
            }
            formula3 = formula3.replaceAll("\\d", "");
            Text text3 = new Text(formula3 + "  ");
            this.bindTextWithValueSet(text3, valueSet);
            this.solutionTextPOS.getChildren().add(text3);
        }
        if (this.kMap.getPrimeImplicantsPOS().size() == 0) {
            this.solutionTextPOS.getChildren().add(new Text("1"));
        }
        int POSgates = this.getGateCount(this.getTextFromTextFlow(this.solutionTextPOS), "+");
        int gateCountPOS = this.getGateCount(this.getTextFromTextFlow(this.solutionTextPOS), "+") + sumPOS;
        this.solutionTextSOP.getChildren().add(new Text("\nGatecount: " + gateCountSOP));
        this.solutionTextPOS.getChildren().add(new Text("\nGatecount: " + gateCountPOS));
        this.solutionTextSOP.getChildren().add(new Text("\n\nSimplified SOP function: \n"));
        this.solutionTextPOS.getChildren().add(new Text("\n\nSimplified POS function: \n"));
        sumSOP = 0;
        sumPOS = 0;
        for (int i3 = 0; i3 < this.kMap.getMinimalCoverSOP().size(); ++i3) {
            ValueSet valueSet = this.kMap.getMinimalCoverSOP().get(i3);
            formula = valueSet.getFormulaSOP(this.letters);
            p = Pattern.compile("\\d+");
            m = p.matcher(formula);
            while (m.find()) {
                sumSOP += Integer.parseInt(m.group());
            }
            formula = formula.replaceAll("\\d", "");
            text = new Text(formula);
            this.bindTextWithValueSet(text, valueSet);
            Text sign = new Text(i3 == this.kMap.getMinimalCoverSOP().size() - 1 ? "" : " + ");
            this.solutionTextSOP.getChildren().addAll((Node[])new Node[]{text, sign});
        }
        if (this.kMap.getMinimalCoverSOP().size() == 0) {
            this.solutionTextSOP.getChildren().add(new Text("0"));
        }
        for (ValueSet valueSet : this.kMap.getMinimalCoverPOS()) {
            formula = valueSet.getFormulaPOS(this.letters);
            p = Pattern.compile("\\d+");
            m = p.matcher(formula);
            while (m.find()) {
                sumPOS += Integer.parseInt(m.group());
            }
            formula = formula.replaceAll("\\d", "");
            text = new Text(formula + "  ");
            this.bindTextWithValueSet(text, valueSet);
            this.solutionTextPOS.getChildren().add(text);
        }
        if (this.kMap.getMinimalCoverPOS().size() == 0) {
            this.solutionTextPOS.getChildren().add(new Text("1"));
        }
        int gateCountSOPMin = this.getGateCount(this.getTextFromTextFlow(this.solutionTextSOP), "+") - SOPgates + sumSOP;
        int gateCountPOSMax = this.getGateCount(this.getTextFromTextFlow(this.solutionTextPOS), "+") - POSgates + sumSOP;
        this.solutionTextSOP.getChildren().add(new Text("\nGatecount: " + gateCountSOPMin));
        this.solutionTextPOS.getChildren().add(new Text("\nGatecount: " + gateCountPOSMax));
        this.updateCanvas();
    }

    private int getGateCount(String formula, String gate) {
        int count = 0;
        int index = 0;
        while ((index = formula.indexOf(gate, index)) != -1) {
            ++count;
            index += gate.length();
        }
        return count;
    }

    public String getTextFromTextFlow(TextFlow textFlow) {
        StringBuilder sb = new StringBuilder();
        for (Node node : textFlow.getChildren()) {
            if (!(node instanceof Text)) continue;
            Text textNode = (Text)node;
            sb.append(textNode.getText());
        }
        return sb.toString();
    }

    private void bindTextWithValueSet(Text text, ValueSet valueSet) {
        text.setFill(Color.web(valueSet.getColor()));
        text.setOnMousePressed(event -> {
            valueSet.setHighlighted(true);
            if (this.show3D.isSelected()) {
                this.cubeModelBuilderSOP.highLightValues(valueSet);
                this.cubeModelBuilderPOS.highLightValues(valueSet);
            } else {
                this.updateCanvas();
            }
        });
        text.setOnMouseReleased(event -> {
            valueSet.setHighlighted(false);
            this.updateCanvas();
        });
    }
}

