/*
 * Decompiled with CFR 0.152.
 */
package project.karnaughmapsolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import project.karnaughmapsolver.ValueSet;

public class KMap {
    private final ValueSet[][][] values;
    private List<ValueSet> primeImplicantsSOP;
    private List<ValueSet> primeImplicantsPOS;
    private List<ValueSet> minimalCoverSOP;
    private List<ValueSet> minimalCoverPOS;

    public KMap(List<ValueSet> valueSets, int var) {
        int i2;
        this.values = this.getMap(var);
        this.primeImplicantsSOP = new ArrayList<ValueSet>();
        this.primeImplicantsPOS = new ArrayList<ValueSet>();
        for (int x = 0; x < this.sizeX(); ++x) {
            for (int y = 0; y < this.sizeY(); ++y) {
                for (int z = 0; z < this.sizeZ(); ++z) {
                    this.values[x][y][z] = valueSets.get(y + x * this.sizeY() + z * this.sizeX() * this.sizeY());
                }
            }
        }
        if (this.sizeX() == 4) {
            ValueSet[][] temp = this.values[3];
            this.values[3] = this.values[2];
            this.values[2] = temp;
        }
        if (this.sizeY() == 4) {
            for (i2 = 0; i2 < this.sizeX(); ++i2) {
                ValueSet[] temp = this.values[i2][3];
                this.values[i2][3] = this.values[i2][2];
                this.values[i2][2] = temp;
            }
        }
        if (this.sizeZ() == 4) {
            for (i2 = 0; i2 < this.sizeX(); ++i2) {
                for (int j = 0; j < this.sizeY(); ++j) {
                    ValueSet temp = this.values[i2][j][3];
                    this.values[i2][j][3] = this.values[i2][j][2];
                    this.values[i2][j][2] = temp;
                }
            }
        }
    }

    public List<ValueSet> getPrimeImplicantsSOP() {
        return this.primeImplicantsSOP;
    }

    public List<ValueSet> getPrimeImplicantsPOS() {
        return this.primeImplicantsPOS;
    }

    public List<ValueSet> getMinimalCoverSOP() {
        return this.minimalCoverSOP;
    }

    public List<ValueSet> getMinimalCoverPOS() {
        return this.minimalCoverPOS;
    }

    public ValueSet getValue(int x, int y, int z) {
        return this.values[x][y][z];
    }

    public int sizeX() {
        return this.values.length;
    }

    public int sizeY() {
        return this.values[0].length;
    }

    public int sizeZ() {
        return this.values[0][0].length;
    }

    private ValueSet[][][] getMap(int variables) {
        return switch (variables) {
            case 2 -> new ValueSet[2][2][1];
            case 3 -> new ValueSet[4][2][1];
            case 4 -> new ValueSet[4][4][1];
            case 5 -> new ValueSet[4][4][2];
            case 6 -> new ValueSet[4][4][4];
            case 7 -> new ValueSet[8][4][4];
            default -> new ValueSet[1][1][1];
        };
    }

    public void findImplicants() {
        this.minimalCoverSOP = new ArrayList<ValueSet>();
        this.minimalCoverPOS = new ArrayList<ValueSet>();
        this.resetValueSets();
        List<ValueSet> foundImplicants = this.getTerms('1', true);
        while (!foundImplicants.isEmpty()) {
            foundImplicants = this.findPrimeImplicants(foundImplicants, true);
        }
        foundImplicants = this.getTerms('0', true);
        while (!foundImplicants.isEmpty()) {
            foundImplicants = this.findPrimeImplicants(foundImplicants, false);
        }
        foundImplicants = this.findEssentialImplicants(this.findTerms('1'), this.minimalCoverSOP, this.primeImplicantsSOP, true);
        foundImplicants = this.findMinimalCover(this.findNonEssentialImplicants(true), foundImplicants, true);
        this.minimalCoverSOP.addAll(foundImplicants);
        foundImplicants = this.findEssentialImplicants(this.findTerms('0'), this.minimalCoverPOS, this.primeImplicantsPOS, true);
        foundImplicants = this.findMinimalCover(this.findNonEssentialImplicants(false), foundImplicants, false);
        this.minimalCoverPOS.addAll(foundImplicants);
        Collections.sort(this.primeImplicantsSOP);
        Collections.reverse(this.primeImplicantsSOP);
        Collections.sort(this.primeImplicantsPOS);
        Collections.reverse(this.primeImplicantsPOS);
        Collections.sort(this.minimalCoverSOP);
        Collections.reverse(this.minimalCoverSOP);
        Collections.sort(this.minimalCoverPOS);
        Collections.reverse(this.minimalCoverPOS);
        this.assignColors();
    }

    private void resetValueSets() {
        for (int x = 0; x < this.sizeX(); ++x) {
            for (int y = 0; y < this.sizeY(); ++y) {
                for (int z = 0; z < this.sizeZ(); ++z) {
                    this.values[x][y][z].resetLinkedImplicants();
                }
            }
        }
    }

    public List<ValueSet> getTerms(char requiredValue, boolean includeDoNotCare) {
        ArrayList<ValueSet> valueSets = new ArrayList<ValueSet>();
        for (int x = 0; x < this.sizeX(); ++x) {
            for (int y = 0; y < this.sizeY(); ++y) {
                for (int z = 0; z < this.sizeZ(); ++z) {
                    if (this.getValue(x, y, z).getF() != requiredValue && (!includeDoNotCare || this.getValue(x, y, z).getF() != '?')) continue;
                    valueSets.add(new ValueSet(this.getValue(x, y, z)));
                }
            }
        }
        return valueSets;
    }

    private List<ValueSet> findTerms(char requiredValue) {
        ArrayList<ValueSet> valueSets = new ArrayList<ValueSet>();
        for (int x = 0; x < this.sizeX(); ++x) {
            for (int y = 0; y < this.sizeY(); ++y) {
                for (int z = 0; z < this.sizeZ(); ++z) {
                    if (this.getValue(x, y, z).getF() != requiredValue) continue;
                    valueSets.add(this.getValue(x, y, z));
                }
            }
        }
        return valueSets;
    }

    private List<ValueSet> findPrimeImplicants(List<ValueSet> oldImplicants, boolean isSOP) {
        ArrayList<ValueSet> foundImplicants = new ArrayList<ValueSet>();
        for (int i2 = 0; i2 < oldImplicants.size(); ++i2) {
            boolean notFound = true;
            ValueSet oldValueSet = oldImplicants.get(i2);
            for (int j = i2 + 1; j < oldImplicants.size(); ++j) {
                ValueSet oldValueSet2 = oldImplicants.get(j);
                ValueSet newValueSet = oldValueSet.getCombinedImplicant(oldValueSet2);
                if (newValueSet == null) continue;
                oldValueSet2.setAdded(true);
                notFound = false;
                if (this.contains(foundImplicants, newValueSet)) continue;
                foundImplicants.add(newValueSet);
            }
            if (!notFound || oldValueSet.isAdded()) continue;
            if (isSOP) {
                this.primeImplicantsSOP.add(oldValueSet);
                continue;
            }
            this.primeImplicantsPOS.add(oldValueSet);
        }
        return foundImplicants;
    }

    private List<ValueSet> findNonEssentialImplicants(boolean isSOP) {
        ArrayList<ValueSet> primeImplicants = new ArrayList<ValueSet>(isSOP ? this.primeImplicantsSOP : this.primeImplicantsPOS);
        List<ValueSet> essentialPrimeImplicants = isSOP ? this.minimalCoverSOP : this.minimalCoverPOS;
        for (ValueSet essentialPrimeImplicant : essentialPrimeImplicants) {
            primeImplicants.remove(essentialPrimeImplicant);
        }
        return primeImplicants;
    }

    private List<ValueSet> findEssentialImplicants(List<ValueSet> terms, List<ValueSet> essentialImplicants, List<ValueSet> primeImplicants, boolean first) {
        if (first) {
            for (ValueSet term : terms) {
                for (ValueSet implicant : primeImplicants) {
                    if (!implicant.contains(term)) continue;
                    term.addImplicant(implicant);
                    implicant.addImplicant(term);
                }
            }
        }
        Collections.sort(terms);
        ArrayList<ValueSet> temp = new ArrayList<ValueSet>(List.copyOf(terms));
        for (ValueSet term : terms) {
            ValueSet implicant;
            if (term.getLinkedImplicants().size() != 1) break;
            implicant = term.getLinkedImplicants().get(0);
            if (essentialImplicants.contains(implicant)) continue;
            essentialImplicants.add(implicant);
            for (ValueSet valueSet : implicant.getLinkedImplicants()) {
                temp.remove(valueSet);
            }
        }
        terms.removeIf(s -> !temp.contains(s));
        return terms;
    }

    private List<ValueSet> findMinimalCover(List<ValueSet> implicants, List<ValueSet> terms, boolean isSOP) {
        ArrayList<ValueSet> newPrimeImplicants = new ArrayList<ValueSet>();
        for (ValueSet implicant : implicants) {
            implicant.getLinkedImplicants().removeIf(s -> !terms.contains(s));
        }
        while (!terms.isEmpty()) {
            Collections.sort(implicants);
            Collections.reverse(implicants);
            ValueSet implicant = implicants.get(0);
            newPrimeImplicants.add(implicant);
            terms.removeIf(s -> implicant.getLinkedImplicants().contains(s));
            for (ValueSet implicant1 : implicants) {
                implicant1.getLinkedImplicants().removeIf(s -> !terms.contains(s));
            }
            implicants.removeIf(s -> s.getLinkedImplicants().size() == 0);
            this.removeCovered(implicants);
            for (ValueSet term : terms) {
                term.getLinkedImplicants().removeIf(s -> !implicants.contains(s));
            }
            terms.removeIf(s -> s.getLinkedImplicants().size() == 0);
            this.findEssentialImplicants(terms, newPrimeImplicants, implicants, false);
            for (ValueSet implicant1 : implicants) {
                implicant1.getLinkedImplicants().removeIf(s -> !terms.contains(s));
            }
            implicants.removeIf(s -> s.getLinkedImplicants().size() == 0);
        }
        return newPrimeImplicants;
    }

    private void removeCovered(List<ValueSet> implicants) {
        ArrayList<ValueSet> temp = new ArrayList<ValueSet>();
        for (int i2 = 0; i2 < implicants.size(); ++i2) {
            block1: for (int j = i2 + 1; j < implicants.size(); ++j) {
                for (ValueSet term : implicants.get(i2).getLinkedImplicants()) {
                    if (implicants.get(j).getLinkedImplicants().contains(term)) continue;
                    continue block1;
                }
                temp.add(implicants.get(i2));
            }
        }
        implicants.removeIf(temp::contains);
    }

    private void assignColors() {
        int i2;
        String[] colors = new String[]{"A93226", "2471A3", "229954", "BA4A00", "884EA0", "17A589", "D4AC0D", "2E4053", "641E16", "1B4F72", "145A32", "6E2C00", "512E5F", "0E6251", "7D6608"};
        for (i2 = 0; i2 < this.primeImplicantsPOS.size(); ++i2) {
            this.primeImplicantsPOS.get(i2).setColor(colors[i2 % 15]);
        }
        for (i2 = 0; i2 < this.primeImplicantsSOP.size(); ++i2) {
            this.primeImplicantsSOP.get(i2).setColor(colors[i2 % 15]);
        }
    }

    private boolean contains(List<ValueSet> foundImplicants, ValueSet newValueSet) {
        for (ValueSet implicant : foundImplicants) {
            if (!implicant.isSame(newValueSet)) continue;
            return true;
        }
        return false;
    }

    public void printKMap(boolean printIndexes) {
        for (int z = 0; z < this.sizeZ(); ++z) {
            for (int y = 0; y < this.sizeY(); ++y) {
                for (int x = 0; x < this.sizeX(); ++x) {
                    if (printIndexes) {
                        System.out.print(this.values[x][y][z].getIndex() + " ");
                        continue;
                    }
                    System.out.print(this.values[x][y][z].getF() + " ");
                }
                System.out.println();
            }
            System.out.println();
            System.out.println();
        }
    }
}

