/*
 * Decompiled with CFR 0.152.
 */
package project.karnaughmapsolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.geometry.Point3D;
import javafx.scene.AmbientLight;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.PerspectiveCamera;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.paint.Color;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import project.karnaughmapsolver.KMap;
import project.karnaughmapsolver.ValueSet;

public class CubeModelBuilder {
    private final Group sceneRoot;
    private final PerspectiveCamera perspectiveCamera;
    private final int numberOfVariables;
    private final KMap kMap;
    private Group meshGroup;
    private Rotate rotateX;
    private Rotate rotateY;
    private final String type;
    public static final float X_RED = 0.071428575f;
    public static final float X_GREEN = 0.21428572f;
    public static final float X_BLUE = 0.35714287f;
    public static final float X_YELLOW = 0.5f;
    public static final float X_ORANGE = 0.64285713f;
    public static final float X_WHITE = 0.78571427f;
    public static final float X_GRAY = 0.9285714f;
    private double mousePosX;
    private double mousePosY;
    private double mouseOldX;
    private double mouseOldY;

    public CubeModelBuilder(Group sceneRoot, PerspectiveCamera perspectiveCamera, int numberOfVariables, KMap kMap, String type) {
        this.sceneRoot = sceneRoot;
        this.perspectiveCamera = perspectiveCamera;
        this.numberOfVariables = numberOfVariables;
        this.kMap = kMap;
        this.type = type;
    }

    public List<int[]> createPatternFaceList(int numberOfVariables) {
        int[] dimensions = new int[3];
        ArrayList<int[]> patternFaces = new ArrayList<int[]>();
        if (numberOfVariables == 5) {
            dimensions[0] = 4;
            dimensions[1] = 4;
            dimensions[2] = 2;
        }
        if (numberOfVariables == 6) {
            dimensions[0] = 4;
            dimensions[1] = 4;
            dimensions[2] = 4;
        }
        if (numberOfVariables == 7) {
            dimensions[0] = 8;
            dimensions[1] = 4;
            dimensions[2] = 4;
        }
        for (int i2 = 0; i2 < dimensions[2]; ++i2) {
            for (int j = 0; j < dimensions[1]; ++j) {
                int k = 0;
                while (k < dimensions[0]) {
                    int[] coordTempArray = new int[]{k++, j, i2, 0, 0, 0};
                    patternFaces.add(coordTempArray);
                }
            }
        }
        return patternFaces;
    }

    public HashMap<List<Integer>, Point3D> createPointList(int numberOfVariables) {
        int[] dimensions = new int[3];
        if (numberOfVariables == 5) {
            dimensions[0] = 4;
            dimensions[1] = 4;
            dimensions[2] = 2;
        }
        if (numberOfVariables == 6) {
            dimensions[0] = 4;
            dimensions[1] = 4;
            dimensions[2] = 4;
        }
        if (numberOfVariables == 7) {
            dimensions[0] = 8;
            dimensions[1] = 4;
            dimensions[2] = 4;
        }
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        HashMap<List<Integer>, Point3D> coordAndPoints = new HashMap<List<Integer>, Point3D>();
        double zCoord = -2.1;
        for (int i2 = 0; i2 < dimensions[2]; ++i2) {
            double yCoord = -2.1;
            for (int j = 0; j < dimensions[1]; ++j) {
                double xCoord = -2.1;
                for (int k = 0; k < dimensions[0]; ++k) {
                    ArrayList<Integer> coordArray = new ArrayList<Integer>();
                    coordArray.add(k);
                    coordArray.add(j);
                    coordArray.add(i2);
                    Point3D point = new Point3D(xCoord, yCoord, zCoord);
                    coordAndPoints.put(coordArray, point);
                    points.add(point);
                    xCoord += 2.1;
                }
                yCoord += 2.1;
            }
            zCoord += 2.1;
        }
        return coordAndPoints;
    }

    private TriangleMesh createCube(int[] face) {
        TriangleMesh m = new TriangleMesh();
        m.getPoints().addAll(0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, 0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, 0.5f, 0.5f, -0.5f, -0.5f, 0.5f, -0.5f, 0.5f, -0.5f, -0.5f, -0.5f, -0.5f);
        m.getTexCoords().addAll(0.071428575f, 0.5f, 0.21428572f, 0.5f, 0.35714287f, 0.5f, 0.5f, 0.5f, 0.64285713f, 0.5f, 0.78571427f, 0.5f, 0.9285714f, 0.5f);
        m.getFaces().addAll(2, face[0], 3, face[0], 6, face[0], 3, face[0], 7, face[0], 6, face[0], 0, face[1], 1, face[1], 2, face[1], 2, face[1], 1, face[1], 3, face[1], 1, face[2], 5, face[2], 3, face[2], 5, face[2], 7, face[2], 3, face[2], 0, face[3], 4, face[3], 1, face[3], 4, face[3], 5, face[3], 1, face[3], 4, face[4], 6, face[4], 5, face[4], 6, face[4], 7, face[4], 5, face[4], 0, face[5], 2, face[5], 4, face[5], 2, face[5], 6, face[5], 4, face[5]);
        return m;
    }

    public SubScene createScene() {
        SubScene subScene = new SubScene(this.sceneRoot, 450.0, 450.0, true, SceneAntialiasing.BALANCED);
        this.perspectiveCamera.setNearClip(0.5);
        this.perspectiveCamera.setFarClip(10000.0);
        this.perspectiveCamera.setTranslateZ(-25.0);
        subScene.setCamera(this.perspectiveCamera);
        this.meshGroup = new Group();
        HashMap<List<Integer>, Point3D> facePoints = this.createPointList(this.numberOfVariables);
        List<int[]> patternFaces = this.createPatternFaceList(this.numberOfVariables);
        for (int[] p : patternFaces) {
            MeshView meshP = new MeshView(this.createCube(p));
            PhongMaterial mat = new PhongMaterial();
            ValueSet value = this.kMap.getValue(p[0], p[1], p[2]);
            Character one = Character.valueOf('1');
            Character question = Character.valueOf('?');
            if (one.equals(Character.valueOf(value.getF()))) {
                mat.setDiffuseColor(Color.BLACK);
            } else if (question.equals(Character.valueOf(value.getF()))) {
                mat.setDiffuseColor(Color.GRAY);
            } else {
                mat.setDiffuseColor(Color.WHITE);
            }
            meshP.setMaterial(mat);
            List<Integer> tempList = Arrays.asList(p[0], p[1], p[2]);
            Point3D pt = facePoints.get(tempList);
            meshP.getTransforms().addAll((Transform[])new Transform[]{new Translate(pt.getX(), pt.getY(), pt.getZ())});
            this.meshGroup.getChildren().add(meshP);
        }
        this.rotateX = new Rotate(0.0, 0.0, 0.0, 0.0, Rotate.X_AXIS);
        this.rotateY = new Rotate(0.0, 0.0, 0.0, 0.0, Rotate.Y_AXIS);
        this.meshGroup.getTransforms().addAll((Transform[])new Transform[]{this.rotateX, this.rotateY});
        this.sceneRoot.getChildren().addAll((Node[])new Node[]{this.meshGroup, new AmbientLight(Color.WHITE)});
        subScene.setOnMousePressed(me -> {
            this.mouseOldX = me.getSceneX();
            this.mouseOldY = me.getSceneY();
        });
        subScene.setOnMouseDragged(me -> {
            this.mousePosX = me.getSceneX();
            this.mousePosY = me.getSceneY();
            this.rotateX.setAngle(this.rotateX.getAngle() - (this.mousePosY - this.mouseOldY));
            this.rotateY.setAngle(this.rotateY.getAngle() + (this.mousePosX - this.mouseOldX));
            this.mouseOldX = this.mousePosX;
            this.mouseOldY = this.mousePosY;
        });
        return subScene;
    }

    public void resetRotation() {
        this.rotateX.setAngle(0.0);
        this.rotateY.setAngle(0.0);
    }

    public void refreshCubeValues() {
        HashMap<List<Integer>, Point3D> facePoints = this.createPointList(this.numberOfVariables);
        for (int i2 = 0; i2 < this.meshGroup.getChildren().size(); ++i2) {
            MeshView meshView = (MeshView)this.meshGroup.getChildren().get(i2);
            Transform meshTransform = (Transform)meshView.getTransforms().get(0);
            Point3D point3D = new Point3D(meshTransform.getTx(), meshTransform.getTy(), meshTransform.getTz());
            List resultList = facePoints.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), point3D)).map(Map.Entry::getKey).collect(Collectors.toList());
            List keyMapCoords = (List)resultList.get(0);
            ValueSet keyMapValues = this.kMap.getValue((Integer)keyMapCoords.get(0), (Integer)keyMapCoords.get(1), (Integer)keyMapCoords.get(2));
            PhongMaterial mat = new PhongMaterial();
            Character one = Character.valueOf('1');
            Character question = Character.valueOf('?');
            if (one.equals(Character.valueOf(keyMapValues.getF()))) {
                mat.setDiffuseColor(Color.BLACK);
            } else if (question.equals(Character.valueOf(keyMapValues.getF()))) {
                mat.setDiffuseColor(Color.GRAY);
            } else {
                mat.setDiffuseColor(Color.WHITE);
            }
            if (keyMapValues.isClicked()) {
                mat.setDiffuseColor(Color.BLUE);
            }
            meshView.setMaterial(mat);
        }
    }

    public void highLightValues(ValueSet valueSet) {
        HashMap<List<Integer>, Point3D> facePoints = this.createPointList(this.numberOfVariables);
        ArrayList<ValueSet> result = new ArrayList<ValueSet>();
        ArrayList<MeshView> meshViews = new ArrayList<MeshView>();
        List<ValueSet> implicantss = this.type.equals("SOP") ? this.kMap.getPrimeImplicantsSOP() : this.kMap.getPrimeImplicantsPOS();
        for (ValueSet implicant : implicantss) {
            if (!implicant.contains(valueSet)) continue;
            result.add(implicant);
        }
        for (int i2 = 0; i2 < this.meshGroup.getChildren().size(); ++i2) {
            MeshView meshView = (MeshView)this.meshGroup.getChildren().get(i2);
            Transform meshTransform = (Transform)meshView.getTransforms().get(0);
            Point3D point3D = new Point3D(meshTransform.getTx(), meshTransform.getTy(), meshTransform.getTz());
            List resultList = facePoints.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), point3D)).map(Map.Entry::getKey).collect(Collectors.toList());
            List keyMapCoords = (List)resultList.get(0);
            ValueSet keyMapValues = this.kMap.getValue((Integer)keyMapCoords.get(0), (Integer)keyMapCoords.get(1), (Integer)keyMapCoords.get(2));
            for (ValueSet set : result) {
                if (!set.contains(keyMapValues)) continue;
                meshViews.add(meshView);
            }
        }
        for (MeshView meshView : meshViews) {
            PhongMaterial mat = new PhongMaterial();
            mat.setDiffuseColor(Color.web(valueSet.getColor(), 1.0));
            meshView.setMaterial(mat);
        }
    }
}

