/*
 * Decompiled with CFR 0.152.
 */
package project.karnaughmapsolver;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ValueSet
implements Comparable<ValueSet> {
    private final char[] binary;
    private char f;
    private List<ValueSet> linkedImplicants = new ArrayList<ValueSet>();
    private boolean added = false;
    private boolean highlighted = false;
    private boolean clicked = false;
    private String color;
    private int index;
    private String letters;

    public ValueSet(int number, int length, char f, int index, String letters) {
        this.binary = Integer.toBinaryString(0x80 | number).substring(8 - length).toCharArray();
        this.f = f;
        this.index = index;
        this.letters = letters;
    }

    public ValueSet(ValueSet valueSet) {
        this.binary = (char[])valueSet.getBinary().clone();
        this.f = valueSet.getF();
    }

    public char[] getBinary() {
        return this.binary;
    }

    public char getF() {
        return this.f;
    }

    public void setF(char f) {
        this.f = f;
    }

    public boolean isAdded() {
        return this.added;
    }

    public void setAdded(boolean added) {
        this.added = added;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getColor() {
        return this.color;
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public void setHighlighted(boolean highlighted) {
        this.highlighted = highlighted;
    }

    public boolean isClicked() {
        return this.clicked;
    }

    public void setClicked(boolean clicked) {
        this.clicked = clicked;
    }

    public List<ValueSet> getLinkedImplicants() {
        return this.linkedImplicants;
    }

    public void resetLinkedImplicants() {
        this.linkedImplicants = new ArrayList<ValueSet>();
    }

    private void setBitDoNotMatter(int i) {
        this.binary[i] = 45;
    }

    public void addImplicant(ValueSet valueSet) {
        this.linkedImplicants.add(valueSet);
    }

    public char getX0() {
        return this.binary[0];
    }

    public char getX1() {
        return this.binary[1];
    }

    public char getX2() {
        return this.binary[2];
    }

    public char getX3() {
        return this.binary[3];
    }

    public char getX4() {
        return this.binary[4];
    }

    public char getX5() {
        return this.binary[5];
    }

    public char getX6() {
        return this.binary[6];
    }

    public int getIndex() {
        return Integer.parseInt(String.valueOf(this.binary), 2);
    }

    public String getFormulaSOP(String lettersString) {
        StringBuilder sb = new StringBuilder();
        int gateCount = 0;
        char[] letterArr = new char[lettersString.length()];
        lettersString.getChars(0, lettersString.length(), letterArr, 0);
        for (int i = 0; i < this.binary.length; ++i) {
            if (this.binary[i] == '0') {
                sb.append('\u00ac');
                sb.append(letterArr[i]);
                gateCount += 2;
                continue;
            }
            if (this.binary[i] != '1') continue;
            sb.append(letterArr[i]);
            ++gateCount;
        }
        if (sb.length() == 0) {
            sb.append(1);
        }
        sb.append(" ");
        sb.append(gateCount);
        return sb.toString();
    }

    public String getFormulaPOS(String lettersString) {
        StringBuilder sb = new StringBuilder();
        int gateCount = 0;
        char[] letterArr = new char[lettersString.length()];
        lettersString.getChars(0, lettersString.length(), letterArr, 0);
        sb.append("(");
        for (int i = 0; i < this.binary.length; ++i) {
            if (this.binary[i] == '0') {
                sb.append(letterArr[i]);
                sb.append("+");
                ++gateCount;
                continue;
            }
            if (this.binary[i] != '1') continue;
            sb.append('\u00ac');
            sb.append(letterArr[i]);
            sb.append("+");
            ++gateCount;
        }
        sb.deleteCharAt(sb.length() - 1);
        if (sb.length() == 0) {
            sb.append(0);
            return sb.toString();
        }
        sb.append(") ");
        sb.append(gateCount);
        return sb.toString();
    }

    public String getSimplifiedSOPFormula() {
        String formula = this.getFormulaSOP(this.letters);
        formula = this.applyBooleanAlgebraReduction(formula, null);
        return formula;
    }

    public String getSimplifiedPOSFormula() {
        String formula = this.getFormulaPOS(this.letters);
        formula = this.applyBooleanAlgebraReduction(formula, null);
        return formula;
    }

    private String applyBooleanAlgebraReduction(String formula, String gateType) {
        int gateCount = 0;
        for (int i = 0; i < this.binary.length; ++i) {
            char searchchar = (char)(65 + i);
            String searchcharInverse = String.valueOf(172 + searchchar);
            if (formula.contains(searchchar + " + " + searchcharInverse) || formula.contains(searchcharInverse + " + " + searchchar)) {
                formula = formula.replace(MessageFormat.format("{0} + {1}", Character.valueOf(searchchar), searchcharInverse), "1");
                formula = formula.replace(MessageFormat.format("{1} + {0}", Character.valueOf(searchchar), searchcharInverse), "1");
                ++gateCount;
            }
            if (formula.contains(searchchar + searchcharInverse) || formula.contains(searchcharInverse + " + " + searchchar)) {
                formula = formula.replace(MessageFormat.format("{0}{1}", Character.valueOf(searchchar), searchcharInverse), "0");
                formula = formula.replace(MessageFormat.format("{1}{0}", Character.valueOf(searchchar), searchcharInverse), "0");
                ++gateCount;
            }
            if (formula.contains(searchchar + " + 0") || formula.contains("0 + " + searchchar)) {
                formula = formula.replace(MessageFormat.format("{0} + 0", Character.valueOf(searchchar)), String.valueOf(searchchar));
                formula = formula.replace(MessageFormat.format("0 + {0}", Character.valueOf(searchchar)), "1");
                ++gateCount;
            }
            if (formula.contains(searchchar + "1") || formula.contains("1" + searchchar)) {
                formula = formula.replace(MessageFormat.format("{0} * 0", Character.valueOf(searchchar)), "0");
                formula = formula.replace(MessageFormat.format("0 * {0}", Character.valueOf(searchchar)), "0");
                ++gateCount;
            }
            if (formula.contains(searchchar + " + " + searchchar)) {
                formula = formula.replace(MessageFormat.format("{0} + {0}", Character.valueOf(searchchar)), String.valueOf(searchchar));
                ++gateCount;
            }
            if (formula.contains(searchchar + " * " + searchchar)) {
                formula = formula.replace(MessageFormat.format("{0} * {0}", Character.valueOf(searchchar)), String.valueOf(searchchar));
                ++gateCount;
            }
            if (formula.contains(searchchar + " + " + searchchar + " + " + searchchar)) {
                formula = formula.replace(MessageFormat.format("{0} + {0} + {0}", Character.valueOf(searchchar)), String.valueOf(searchchar));
                ++gateCount;
            }
            if (formula.contains(searchchar + " * " + searchchar + " * " + searchchar)) {
                formula = formula.replace(MessageFormat.format("{0} * {0} * {0}", Character.valueOf(searchchar)), String.valueOf(searchchar));
                ++gateCount;
            }
            for (int j = i + 1; j < this.binary.length; ++j) {
                char searchchar2 = (char)(65 + j);
                String searchchar2Inverse = String.valueOf(172 + searchchar2);
                if (formula.contains(searchchar + " * (" + searchchar2 + " + " + searchchar2Inverse + ")")) {
                    formula = formula.replace(MessageFormat.format("{0} * ({1} + {2})", Character.valueOf(searchchar), Character.valueOf(searchchar2), searchchar2Inverse), MessageFormat.format("{0} * {1} + {0} * {2}", Character.valueOf(searchchar), Character.valueOf(searchchar2), searchchar2Inverse));
                    gateCount += 2;
                }
                if (!formula.contains("(" + searchchar + " + " + searchcharInverse + ") * " + searchchar2)) continue;
                formula = formula.replace(MessageFormat.format("({0} + {1}) * {2}", Character.valueOf(searchchar), searchcharInverse, Character.valueOf(searchchar2)), MessageFormat.format("{0} * {2} + {1} * {2}", Character.valueOf(searchchar), searchcharInverse, Character.valueOf(searchchar2)));
                gateCount += 2;
            }
            if (formula.contains("(" + searchchar + " + " + searchcharInverse + ")'")) {
                formula = formula.replace(MessageFormat.format("({0} + {1})'", Character.valueOf(searchchar), searchcharInverse), MessageFormat.format("{0}' * {1}'", Character.valueOf(searchchar), searchcharInverse));
                gateCount += 2;
            }
            if (!formula.contains("(" + searchchar + " * " + searchcharInverse + ")'")) continue;
            formula = formula.replace(MessageFormat.format("({0} * {1})'", Character.valueOf(searchchar), searchcharInverse), MessageFormat.format("{0}' + {1}'", Character.valueOf(searchchar), searchcharInverse));
            gateCount += 2;
        }
        if (gateType != null) {
            switch (gateType) {
                case "NAND": {
                    formula = this.replaceGatesWithNANDs(formula);
                    break;
                }
                case "XOR": {
                    formula = this.replaceGatesWithXORs(formula);
                    break;
                }
                case "NOR": {
                    formula = this.replaceGatesWithNORs(formula);
                }
            }
        }
        return formula;
    }

    private String replaceGatesWithNANDs(String formula) {
        formula = formula.replace('+', '\u22bc');
        formula = formula.replace('*', '+');
        formula = formula.replace('\u22bc', '*');
        return formula;
    }

    private String replaceGatesWithXORs(String formula) {
        formula = formula.replace('+', '\u2295');
        formula = formula.replace('*', '+');
        formula = formula.replace('\u2295', '*');
        return formula;
    }

    private String replaceGatesWithNORs(String formula) {
        formula = formula.replace('*', '\u2193');
        return formula;
    }

    public String getSimplifiedPOSFormulaWithGates(String gateType) {
        String formula = this.getFormulaPOS(this.letters);
        formula = this.applyBooleanAlgebraReduction(formula, gateType);
        return formula;
    }

    public String getSimplifiedSOPFormulaWithGates(String gateType) {
        String formula = this.getFormulaSOP(this.letters);
        formula = this.applyBooleanAlgebraReduction(formula, gateType);
        return formula;
    }

    public ValueSet getCombinedImplicant(ValueSet valueSet) {
        int dif = 0;
        int idx = 0;
        for (int i = 0; i < this.binary.length; ++i) {
            if (this.binary[i] == valueSet.getBinary()[i]) continue;
            ++dif;
            idx = i;
        }
        if (dif == 1) {
            ValueSet result = new ValueSet(valueSet);
            result.setBitDoNotMatter(idx);
            return result;
        }
        return null;
    }

    public boolean isSame(ValueSet valueSet) {
        for (int i = 0; i < this.binary.length; ++i) {
            if (this.binary[i] == valueSet.getBinary()[i]) continue;
            return false;
        }
        return true;
    }

    public boolean contains(ValueSet valueSet) {
        for (int i = 0; i < this.binary.length; ++i) {
            if (this.binary[i] == '-' || this.binary[i] == valueSet.getBinary()[i]) continue;
            return false;
        }
        return true;
    }

    public void rotateF() {
        switch (this.f) {
            case '0': {
                this.f = (char)49;
                break;
            }
            case '1': {
                this.f = (char)63;
                break;
            }
            case '?': {
                this.f = (char)48;
            }
        }
    }

    @Override
    public int compareTo(ValueSet o) {
        int b;
        int a = this.linkedImplicants.size();
        if (a == (b = o.linkedImplicants.size())) {
            return Arrays.toString(this.binary).compareTo(Arrays.toString(o.binary));
        }
        return Integer.compare(a, b);
    }

    public String toString() {
        return "ValueSet{binary=" + Arrays.toString(this.binary) + ", f=" + this.f + ", primeImplicants=" + this.linkedImplicants.size() + "}";
    }
}

