/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MAIN_H
#define __MAIN_H

/* Includes ------------------------------------------------------------------*/
#include "stm32l4xx_hal.h"
#include "stm32l4xx_nucleo.h"
#include "usart.h"
#include "log.h"

/* Definition for I2Cx clock resources */
#define I2Cx I2C3
#define RCC_PERIPHCLK_I2Cx RCC_PERIPHCLK_I2C3
#define RCC_I2CxCLKSOURCE_SYSCLK RCC_I2C3CLKSOURCE_SYSCLK
#define I2Cx_CLK_ENABLE() __HAL_RCC_I2C3_CLK_ENABLE()
#define I2Cx_SDA_GPIO_CLK_ENABLE() __HAL_RCC_GPIOC_CLK_ENABLE()
#define I2Cx_SCL_GPIO_CLK_ENABLE() __HAL_RCC_GPIOC_CLK_ENABLE()

#define I2Cx_FORCE_RESET() __HAL_RCC_I2C3_FORCE_RESET()
#define I2Cx_RELEASE_RESET() __HAL_RCC_I2C3_RELEASE_RESET()

/* Definition for I2Cx Pins */
#define I2Cx_SCL_PIN GPIO_PIN_0
#define I2Cx_SCL_GPIO_PORT GPIOC
#define I2Cx_SDA_PIN GPIO_PIN_1
#define I2Cx_SDA_GPIO_PORT GPIOC
#define I2Cx_SCL_SDA_AF GPIO_AF4_I2C3

#define B1_Pin GPIO_PIN_13
#define B1_GPIO_Port GPIOC
#define USART_TX_Pin GPIO_PIN_2
#define USART_TX_GPIO_Port GPIOA
#define USART_RX_Pin GPIO_PIN_3
#define USART_RX_GPIO_Port GPIOA
#define LD2_Pin GPIO_PIN_5
#define LD2_GPIO_Port GPIOA
#define TMS_Pin GPIO_PIN_13
#define TMS_GPIO_Port GPIOA
#define TCK_Pin GPIO_PIN_14
#define TCK_GPIO_Port GPIOA
#define SWO_Pin GPIO_PIN_3
#define SWO_GPIO_Port GPIOB

/* Size of Transmission buffer */
#define TXBUFFERSIZE (COUNTOF(aTxBuffer) - 1)
/* Size of Reception buffer */
#define RXBUFFERSIZE TXBUFFERSIZE

/* Exported macro ------------------------------------------------------------*/
#define COUNTOF(__BUFFER__) (sizeof(__BUFFER__) / sizeof(*(__BUFFER__)))
/* Exported functions ------------------------------------------------------- */

#endif /* __MAIN_H */
