#ifndef INC_LOG_H_
#define INC_LOG_H_

#include <stdint.h>
#include "main.h"

#define LOGLEVEL_OFF (99)
#define LOGLEVEL_TRACE (1)
#define LOGLEVEL_DEBUG (2)
#define LOGLEVEL_WARN (3)
#define LOGLEVEL_ERROR (4)

// Change these vars
#define USELOGLEVEL LOGLEVEL_TRACE
#define MSG_SIZE 100
//

void compareBufLog(uint8_t *pBuffer1, uint8_t *pBuffer2, uint16_t BufferLength);
uint16_t Buffercmp(uint8_t *pBuffer1, uint8_t *pBuffer2, uint16_t BufferLength);
void _log_process_msg(char *msg, uint16_t len);
extern char msg[MSG_SIZE];

#define LOG_TRACE(FORMAT, ...) LOG_AT_LOG_LEVEL(LOGLEVEL_TRACE, "TRACE", FORMAT, ##__VA_ARGS__)
#define LOG_DEBUG(FORMAT, ...) LOG_AT_LOG_LEVEL(LOGLEVEL_DEBUG, "DEBUG", FORMAT, ##__VA_ARGS__)
#define LOG_WARNING(FORMAT, ...) LOG_AT_LOG_LEVEL(LOGLEVEL_WARN, "WARNING", FORMAT, ##__VA_ARGS__)
#define LOG_ERROR(FORMAT, ...) LOG_AT_LOG_LEVEL(LOGLEVEL_ERROR, "ERROR", FORMAT, ##__VA_ARGS__)

#define LOG_AT_LOG_LEVEL(LOGLEVEL, TYPE, FORMAT, ...)                                                                                 \
	if (LOGLEVEL >= USELOGLEVEL)                                                                                                      \
	{                                                                                                                                 \
		uint16_t len = snprintf(msg, MSG_SIZE, "%d:" TYPE ":%s:%d:::" FORMAT "\n", HAL_GetTick(), __func__, __LINE__, ##__VA_ARGS__); \
		_log_process_msg(msg, len);                                                                                                   \
	}

#endif /* INC_LOG_H_ */
